/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.RoleType;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntityLiving;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.event.CustomGuiEvent;
import noppes.npcs.api.event.ItemEvent;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.event.QuestEvent;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.api.item.ISpecBuilder;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.controllers.CustomGuiController;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.PlayerSkinController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.BankData;
import noppes.npcs.controllers.data.Deal;
import noppes.npcs.controllers.data.DealMarkup;
import noppes.npcs.controllers.data.ForgeScriptData;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.Marcet;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.NpcScriptData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.controllers.data.PlayerGameData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.PlayerMailData;
import noppes.npcs.controllers.data.PlayerOverlayHUD;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.controllers.data.PotionScriptData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataAnimation;
import noppes.npcs.entity.data.DataInventory;
import noppes.npcs.entity.data.DataScript;
import noppes.npcs.items.ItemBuilder;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.roles.RoleTransporter;
import noppes.npcs.util.BuilderData;
import noppes.npcs.util.ScriptEncryption;
import noppes.npcs.util.TempFile;
import noppes.npcs.util.Util;

public class PacketHandlerPlayer {
    private static List<EnumPlayerPacket> list = new ArrayList<EnumPlayerPacket>();

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        ByteBuf buffer = event.getPacket().payload();
        Objects.requireNonNull(player.func_184102_h()).func_152344_a(() -> {
            EnumPlayerPacket type = null;
            try {
                type = EnumPlayerPacket.values()[buffer.readInt()];
                CustomNpcs.debugData.start(type.toString());
                if (!list.contains((Object)type)) {
                    LogWriter.debug("Received: " + (Object)((Object)type));
                }
                this.player(buffer, player, type);
                CustomNpcs.debugData.end(type.toString());
            }
            catch (Exception e) {
                LogWriter.error("Error with EnumPlayerPacket." + (Object)((Object)type), e);
            }
            finally {
                buffer.release();
            }
        });
    }

    private void player(ByteBuf buffer, EntityPlayerMP player, EnumPlayerPacket type) throws Exception {
        PlayerData data = PlayerData.get((EntityPlayer)player);
        if (type == EnumPlayerPacket.MarkData) {
            Entity entity = Objects.requireNonNull(player.func_184102_h()).func_175576_a(Server.readUUID(buffer));
            if (!(entity instanceof EntityLivingBase)) {
                return;
            }
            MarkData.get((EntityLivingBase)entity);
        } else if (type == EnumPlayerPacket.KeyPressed) {
            PlayerOverlayHUD hud = data.hud;
            int key = buffer.readInt();
            if (key < 0) {
                for (int k : hud.keyPress) {
                    EventHooks.onPlayerKeyPressed(player, k, false, false, false, false, false);
                }
                hud.keyPress.clear();
                return;
            }
            boolean isDown = buffer.readBoolean();
            if (isDown) {
                hud.keyPress.add(key);
            } else if (hud.hasOrKeysPressed(key)) {
                hud.keyPress.remove((Object)key);
            }
            if (!CustomNpcs.EnableScripting || ScriptController.Instance.languages.isEmpty()) {
                return;
            }
            EventHooks.onPlayerKeyPressed(player, key, isDown, buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean());
        } else if (type == EnumPlayerPacket.MousesPressed) {
            PlayerOverlayHUD hud = data.hud;
            int key = buffer.readInt();
            if (key < 0) {
                hud.mousePress.clear();
                return;
            }
            boolean isDown = buffer.readBoolean();
            if (isDown) {
                hud.mousePress.add(key);
            } else if (hud.hasMousePress(key)) {
                hud.mousePress.remove((Object)key);
            }
            if (!CustomNpcs.EnableScripting || ScriptController.Instance.languages.isEmpty()) {
                return;
            }
            EventHooks.onPlayerMousePressed(player, key, isDown, buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean());
        } else if (type == EnumPlayerPacket.LeftClick) {
            if (!CustomNpcs.EnableScripting || ScriptController.Instance.languages.isEmpty()) {
                return;
            }
            ItemStack item = player.func_184614_ca();
            PlayerScriptData handler = data.scriptData;
            PlayerEvent.AttackEvent ev = new PlayerEvent.AttackEvent(handler.getPlayer(), 0, null);
            EventHooks.onPlayerAttack(handler, ev);
            if (item.func_77973_b() == CustomRegisters.scripted_item) {
                ItemScriptedWrapper isw = ItemScripted.GetWrapper(item);
                ItemEvent.AttackEvent eve = new ItemEvent.AttackEvent(isw, handler.getPlayer(), 0, null);
                EventHooks.onScriptItemAttack(isw, eve);
            }
        } else if (type == EnumPlayerPacket.CustomGuiClose) {
            ICustomGui gui = new CustomGuiWrapper((EntityPlayer)player).fromNBT(Server.readNBT(buffer));
            EventHooks.onCustomGuiClose((PlayerWrapper)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), gui);
        } else if (type == EnumPlayerPacket.CustomGuiButton) {
            if (player.field_71070_bA instanceof ContainerCustomGui) {
                ((ContainerCustomGui)player.field_71070_bA).customGui.fromNBT(Server.readNBT(buffer));
                EventHooks.onCustomGuiButton((PlayerWrapper)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), ((ContainerCustomGui)player.field_71070_bA).customGui, buffer.readInt());
            }
        } else if (type == EnumPlayerPacket.CustomGuiScrollClick) {
            if (player.field_71070_bA instanceof ContainerCustomGui) {
                ((ContainerCustomGui)player.field_71070_bA).customGui.fromNBT(Server.readNBT(buffer));
                EventHooks.onCustomGuiScrollClick((PlayerWrapper)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), ((ContainerCustomGui)player.field_71070_bA).customGui, buffer.readInt(), buffer.readInt(), CustomGuiController.readScrollSelection(buffer), buffer.readBoolean());
            }
        } else if (type == EnumPlayerPacket.CloseGui) {
            player.func_71128_l();
        } else if (type == EnumPlayerPacket.CompanionTalentExp) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || !(npc.advanced.roleInterface instanceof RoleCompanion) || player != npc.getOwner()) {
                return;
            }
            int id = buffer.readInt();
            int exp = buffer.readInt();
            RoleCompanion role = (RoleCompanion)npc.advanced.roleInterface;
            if (exp <= 0 || !role.canAddExp(-exp) || id < 0 || id >= EnumCompanionTalent.values().length) {
                return;
            }
            EnumCompanionTalent talent = EnumCompanionTalent.values()[id];
            role.addExp(-exp);
            role.addTalentExp(talent, exp);
        } else if (type == EnumPlayerPacket.CompanionOpenInv) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || !(npc.advanced.roleInterface instanceof RoleCompanion) || player != npc.getOwner()) {
                return;
            }
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.CompanionInv, npc);
        } else if (type == EnumPlayerPacket.FollowerHire) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.roleInterface.getEnumType() != RoleType.FOLLOWER) {
                return;
            }
            NoppesUtilPlayer.hireFollower(player, npc, buffer.readInt());
        } else if (type == EnumPlayerPacket.FollowerExtend) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.roleInterface.getEnumType() != RoleType.FOLLOWER) {
                return;
            }
            NoppesUtilPlayer.extendFollower(player, npc, buffer.readInt());
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.advanced.roleInterface.save(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.FollowerState) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.roleInterface.getEnumType() != RoleType.FOLLOWER) {
                return;
            }
            int t = buffer.readInt();
            if (t == 0) {
                NoppesUtilPlayer.changeFollowerState(player, npc);
                Server.sendData(player, EnumPacketClient.GUI_DATA, npc.advanced.roleInterface.save(new NBTTagCompound()));
            } else if (t == 1) {
                PlayerGameData.FollowerSet fs;
                RoleFollower role = (RoleFollower)npc.advanced.roleInterface;
                RoleEvent.FollowerFinishedEvent event = new RoleEvent.FollowerFinishedEvent(role.owner, npc.wrappedNPC);
                EventHooks.onNPCRole(npc, event);
                npc.say(role.owner, new Line(new TextComponentTranslation(NoppesStringUtils.formatText(role.dialogFired, new Object[]{role.owner, npc}), new Object[0]).func_150254_d()));
                if (data != null && (fs = data.game.getFollower(role.npc)) != null) {
                    data.game.removeFollower(role.npc);
                }
                role.killed();
            }
        } else if (type == EnumPlayerPacket.RoleGet) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null) {
                return;
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.advanced.roleInterface.save(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.Transport) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || !(npc.advanced.roleInterface instanceof RoleTransporter)) {
                return;
            }
            ((RoleTransporter)npc.advanced.roleInterface).transport(player, buffer.readInt());
        } else if (type == EnumPlayerPacket.BankUpgrade) {
            EntityNPCInterface npc;
            if (!(player.field_71070_bA instanceof ContainerNPCBank)) {
                return;
            }
            Entity e = player.field_70170_p.func_73045_a(buffer.readInt());
            if (e instanceof EntityNPCInterface) {
                npc = (EntityNPCInterface)e;
                NoppesUtilServer.setEditingNpc((EntityPlayer)player, npc);
            } else {
                npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            }
            if (npc == null || npc.advanced.roleInterface.getEnumType() != RoleType.BANK) {
                return;
            }
            NoppesUtilPlayer.bankUpgrade(player, npc, buffer.readBoolean(), buffer.readInt());
        } else if (type == EnumPlayerPacket.BankRegrade) {
            Entity e;
            if (!(player.field_71070_bA instanceof ContainerNPCBank)) {
                return;
            }
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null && (e = player.field_70170_p.func_73045_a(buffer.readInt())) instanceof EntityNPCInterface) {
                npc = (EntityNPCInterface)e;
                NoppesUtilServer.setEditingNpc((EntityPlayer)player, npc);
            }
            if (!player.field_71075_bZ.field_75098_d || npc == null || npc.advanced.roleInterface.getEnumType() != RoleType.BANK) {
                return;
            }
            NoppesUtilPlayer.bankRegrade(player, npc);
        } else if (type == EnumPlayerPacket.BankUnlock) {
            Entity e;
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null && (e = player.field_70170_p.func_73045_a(buffer.readInt())) instanceof EntityNPCInterface) {
                npc = (EntityNPCInterface)e;
                NoppesUtilServer.setEditingNpc((EntityPlayer)player, npc);
            }
            if (!(player.field_71070_bA instanceof ContainerNPCBank) || npc == null || npc.advanced.roleInterface.getEnumType() != RoleType.BANK) {
                Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
                return;
            }
            NoppesUtilPlayer.bankUnlock(player, npc, buffer.readBoolean());
        } else if (type == EnumPlayerPacket.BankLock) {
            Entity e;
            if (!(player.field_71070_bA instanceof ContainerNPCBank)) {
                return;
            }
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null && (e = player.field_70170_p.func_73045_a(buffer.readInt())) instanceof EntityNPCInterface) {
                npc = (EntityNPCInterface)e;
                NoppesUtilServer.setEditingNpc((EntityPlayer)player, npc);
            }
            if (!player.field_71075_bZ.field_75098_d || npc == null || npc.advanced.roleInterface.getEnumType() != RoleType.BANK) {
                return;
            }
            NoppesUtilPlayer.bankLock(player, npc);
        } else if (type == EnumPlayerPacket.BankClearCeil) {
            Entity e;
            if (!(player.field_71070_bA instanceof ContainerNPCBank)) {
                return;
            }
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null && (e = player.field_70170_p.func_73045_a(buffer.readInt())) instanceof EntityNPCInterface) {
                npc = (EntityNPCInterface)e;
                NoppesUtilServer.setEditingNpc((EntityPlayer)player, npc);
            }
            if (!player.field_71075_bZ.field_75098_d || npc == null || npc.advanced.roleInterface.getEnumType() != RoleType.BANK) {
                return;
            }
            NoppesUtilPlayer.bankClearCeil(player, npc);
        } else if (type == EnumPlayerPacket.BankResetCeil) {
            Entity e;
            if (!(player.field_71070_bA instanceof ContainerNPCBank)) {
                return;
            }
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null && (e = player.field_70170_p.func_73045_a(buffer.readInt())) instanceof EntityNPCInterface) {
                npc = (EntityNPCInterface)e;
                NoppesUtilServer.setEditingNpc((EntityPlayer)player, npc);
            }
            if (!player.field_71075_bZ.field_75098_d || npc == null || npc.advanced.roleInterface.getEnumType() != RoleType.BANK) {
                return;
            }
            NoppesUtilPlayer.bankResetCeil(player, npc);
        } else if (type == EnumPlayerPacket.Dialog) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            int dialogId = buffer.readInt();
            int optionId = buffer.readInt();
            data.dialogData.option(dialogId, optionId);
            if (npc == null) {
                return;
            }
            NoppesUtilPlayer.dialogSelected(dialogId, optionId, player, npc);
        } else if (type == EnumPlayerPacket.CheckQuestCompletion) {
            int id = buffer.readInt();
            PlayerQuestData playerdata = PlayerData.get((EntityPlayer)player).questData;
            for (QuestData qd : playerdata.activeQuests.values()) {
                if (id > 0 && qd.quest.id != id) continue;
                playerdata.checkQuestCompletion((EntityPlayer)player, qd);
            }
        } else if (type == EnumPlayerPacket.QuestCompletion) {
            NoppesUtilPlayer.questCompletion(player, buffer.readInt());
        } else if (type == EnumPlayerPacket.QuestCompletionReward) {
            int id = buffer.readInt();
            ItemStack stack = new ItemStack(Server.readNBT(buffer));
            NoppesUtilPlayer.questCompletion(player, id, stack);
        } else if (type == EnumPlayerPacket.FactionsGet) {
            PlayerFactionData data2 = data.factionData;
            Server.sendData(player, EnumPacketClient.GUI_DATA, data2.getPlayerGuiData());
        } else if (type == EnumPlayerPacket.MailGet) {
            PlayerMailData data3 = data.mailData;
            Server.sendData(player, EnumPacketClient.GUI_DATA, data3.saveNBTData(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.MailReturn) {
            long id = buffer.readLong();
            PlayerMail mail = data.mailData.get(id);
            if (mail == null) {
                return;
            }
            PlayerData plData = PlayerDataController.instance.getDataFromUsername(Objects.requireNonNull(player.field_70170_p.func_73046_m()), mail.sender);
            if (plData == null) {
                if (!mail.sender.isEmpty()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("mailbox.error.return.player", new Object[]{mail.sender}));
                }
            } else {
                mail.sender = mail.sender + new TextComponentTranslation("mailbox.returned", new Object[0]).func_150254_d();
                mail.returned = true;
                mail.ransom = 0;
                mail.beenRead = false;
                plData.mailData.addMail(mail);
                plData.save(false);
            }
            Iterator<PlayerMail> it = data.mailData.playerMails.iterator();
            while (it.hasNext()) {
                PlayerMail m = it.next();
                if (m.timeWhenReceived != id || !m.sender.equals(mail.sender)) continue;
                it.remove();
                break;
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, data.mailData.saveNBTData(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.MailDelete) {
            long time = buffer.readLong();
            PlayerMailData mailData = data.mailData;
            if (time < 0L) {
                ArrayList del = Lists.newArrayList();
                long serverTime = System.currentTimeMillis();
                for (PlayerMail mail : mailData.playerMails) {
                    if (serverTime - mail.timeWhenReceived - mail.timeWillCome < 0L) continue;
                    del.add(mail);
                }
                for (PlayerMail mail : del) {
                    mailData.playerMails.remove(mail);
                }
                NBTTagCompound compound = new NBTTagCompound();
                mailData.saveNBTData(compound);
                Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.MailData, compound});
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
                return;
            }
            if (time == 0L) {
                ArrayList del = Lists.newArrayList();
                for (PlayerMail mail : mailData.playerMails) {
                    if (!mail.beenRead) continue;
                    del.add(mail);
                }
                for (PlayerMail mail : del) {
                    mailData.playerMails.remove(mail);
                }
                NBTTagCompound compound = new NBTTagCompound();
                mailData.saveNBTData(compound);
                Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.MailData, compound});
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
                return;
            }
            String username = Server.readString(buffer);
            Iterator<PlayerMail> it = mailData.playerMails.iterator();
            while (it.hasNext()) {
                PlayerMail mail = it.next();
                if (mail.timeWhenReceived != time || !mail.sender.equals(username)) continue;
                it.remove();
                break;
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, mailData.saveNBTData(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.MailSend) {
            String username = Server.readString(buffer);
            boolean isCreative = player.field_71075_bZ.field_75098_d;
            assert (username != null);
            if (username.equalsIgnoreCase(player.func_70005_c_()) && !CustomNpcs.MailSendToYourself && !isCreative) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 2);
                return;
            }
            if (PlayerDataController.instance.hasPlayer(username).isEmpty()) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 0);
                return;
            }
            long cost = buffer.readLong();
            if (!isCreative && cost > data.game.getMoney()) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 3);
                return;
            }
            PlayerMail mail = new PlayerMail();
            String s = player.getDisplayNameString();
            if (!s.equals(player.func_70005_c_())) {
                s = s + "(" + player.func_70005_c_() + ")";
            }
            mail.readNBT(Server.readNBT(buffer));
            if (mail.title.isEmpty()) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 1);
                return;
            }
            mail.sender = s;
            mail.items = ((ContainerMail)player.field_71070_bA).mail.items;
            ((ContainerMail)player.field_71070_bA).sendMail = true;
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74778_a("username", username);
            NoppesUtilServer.sendGuiClose(player, 1, comp);
            EntityNPCInterface npc2 = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc2 != null && EventHooks.onNPCRole(npc2, new RoleEvent.MailmanEvent((EntityPlayer)player, npc2.wrappedNPC, mail))) {
                return;
            }
            PlayerDataController.instance.addPlayerMessage(player.func_184102_h(), username, mail);
        } else if (type == EnumPlayerPacket.MailboxOpenMail) {
            long time = buffer.readLong();
            String username = Server.readString(buffer);
            int x = buffer.readInt();
            int y = buffer.readInt();
            player.func_71128_l();
            if (x == 1 && y == 1) {
                player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailOpen.ordinal(), player.field_70170_p, 1, 1, 0);
                return;
            }
            PlayerMailData data4 = data.mailData;
            for (PlayerMail mail : data4.playerMails) {
                if (mail.timeWhenReceived != time || !mail.sender.equals(username)) continue;
                ContainerMail.staticmail = mail;
                player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailOpen.ordinal(), player.field_70170_p, 0, 0, 0);
                break;
            }
        } else if (type == EnumPlayerPacket.MailRead) {
            long time = buffer.readLong();
            String username = Server.readString(buffer);
            PlayerMailData data4 = data.mailData;
            for (PlayerMail mail : data4.playerMails) {
                if (mail.beenRead || mail.timeWhenReceived != time || !mail.sender.equals(username)) continue;
                if (mail.hasQuest()) {
                    PlayerQuestController.addActiveQuest(mail.getQuest(), (EntityPlayer)player, false);
                }
                mail.beenRead = true;
            }
        } else if (type == EnumPlayerPacket.QuestRemoveActive) {
            int id = buffer.readInt();
            IQuest quest = QuestController.instance.get(id);
            if (quest == null) {
                return;
            }
            boolean bo = EventHooks.onQuestCanceled(data.scriptData, (Quest)quest);
            if (!bo && PlayerQuestController.getRemoveActiveQuest((EntityPlayer)player, id)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.removequest", new Object[]{quest.getTitle()}));
                Server.sendData(player, EnumPacketClient.GUI_DATA, new NBTTagCompound());
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.removequest.not", new Object[]{quest.getTitle()}));
            }
        } else if (type == EnumPlayerPacket.QuestChooseReward) {
            int id = buffer.readInt();
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.QuestRewardItem, null, id, 0, 0);
        } else if (type == EnumPlayerPacket.NpcVisualData) {
            int entityID = buffer.readInt();
            Entity entity = player.field_70170_p.func_73045_a(entityID);
            if (entity instanceof EntityNPCInterface) {
                NBTTagCompound compound = new NBTTagCompound();
                EntityNPCInterface npcData = (EntityNPCInterface)entity;
                compound.func_74768_a("NPCLevel", npcData.stats.getLevel());
                compound.func_74768_a("NPCRarity", npcData.stats.getRarity());
                compound.func_74778_a("RarityTitle", npcData.stats.getRarityTitle());
                Server.sendData(player, EnumPacketClient.NPC_VISUAL_DATA, entityID, compound);
            }
        } else if (type == EnumPlayerPacket.IsMoved) {
            data.hud.isMoved = buffer.readBoolean();
        } else if (type == EnumPlayerPacket.WindowSize) {
            PlayerOverlayHUD hud = data.hud;
            NBTTagCompound compound = Server.readNBT(buffer);
            hud.setWindowSize(compound.func_150295_c("WindowSize", 6));
        } else if (type == EnumPlayerPacket.TraderMarketBuy) {
            Marcet marcet = (Marcet)MarcetController.getInstance().getMarcet(buffer.readInt());
            if (marcet == null || marcet.notHasListener((EntityPlayer)player)) {
                Server.sendData(player, EnumPacketClient.MARCET_DATA, 2);
                Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
                return;
            }
            Deal deal = marcet.getDeal(buffer.readInt());
            if (deal == null || deal.getType() == 1 || deal.getProduct().isEmpty()) {
                Server.sendData(player, EnumPacketClient.MARCET_DATA, 2);
                Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
                return;
            }
            boolean canGiveItem = deal.availability.isAvailable((EntityPlayer)player);
            DealMarkup dm = MarcetController.getInstance().getBuyData(marcet, deal, data.game.getMarcetLevel(marcet.getId()));
            if (!player.field_71075_bZ.field_75098_d) {
                if (canGiveItem && dm.buyMoney > data.game.getMoney()) {
                    canGiveItem = false;
                }
                if (canGiveItem) {
                    canGiveItem = Util.instance.canRemoveItems((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, dm.buyItems, dm.ignoreDamage, dm.ignoreNBT);
                }
            }
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            IEntityLiving npc = null;
            if (entity instanceof EntityNPCInterface) {
                npc = (ICustomNpc)Objects.requireNonNull(NpcAPI.Instance()).getIEntity(entity);
            }
            if (!canGiveItem) {
                assert (npc != null);
                EventHooks.onNPCRole((EntityNPCInterface)((Object)npc.getMCEntity()), new RoleEvent.TradeFailedEvent((EntityPlayer)player, (ICustomNpc<?>)npc, dm.main, dm.buyItems));
                Server.sendData(player, EnumPacketClient.MARCET_DATA, 2);
                Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
                return;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                data.game.addMoney(-1L * dm.buyMoney);
                for (ItemStack st : dm.buyItems.keySet()) {
                    Util.instance.removeItem(player, st, dm.buyItems.get(st), dm.ignoreDamage, dm.ignoreNBT);
                }
            }
            if (deal.getMaxCount() > 0 && deal.getAmount() < dm.count) {
                dm.count = deal.getAmount();
                if (dm.count == 0) {
                    dm.count = dm.main.func_190916_E();
                }
            }
            boolean bo = false;
            ItemStack stack = dm.main.func_77946_l();
            if (dm.count > dm.main.func_77976_d()) {
                for (int c = dm.count; c > 0; c -= dm.main.func_77976_d()) {
                    stack = dm.main.func_77946_l();
                    stack.func_190920_e(Math.min(c, dm.main.func_77976_d()));
                    boolean b = player.field_71071_by.func_70441_a(stack);
                    if (!b || bo) continue;
                    bo = true;
                }
            } else {
                stack.func_190920_e(dm.count);
                boolean bl = bo = dm.count > 0 && player.field_71071_by.func_70441_a(stack);
            }
            assert (npc != null);
            if (bo) {
                if (deal.getMaxCount() != 0) {
                    deal.setAmount(deal.getAmount() - dm.count);
                }
                if (CustomNpcs.SendMarcetInfo) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("mes.market.buy", new Object[]{dm.main.func_82833_r() + " x" + dm.count}));
                }
                NoppesUtilServer.playSound((EntityLivingBase)player, SoundEvents.field_187638_cR, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                Util.instance.updatePlayerInventory(player);
                data.game.addMarkupXP(marcet.getId(), 5);
                EventHooks.onNPCRole((EntityNPCInterface)((Object)npc.getMCEntity()), new RoleEvent.TraderEvent((EntityPlayer)player, (ICustomNpc<?>)npc, dm.main, dm.buyItems));
                marcet.detectAndSendChanges();
            } else {
                EventHooks.onNPCRole((EntityNPCInterface)((Object)npc.getMCEntity()), new RoleEvent.TradeFailedEvent((EntityPlayer)player, (ICustomNpc<?>)npc, dm.main, dm.buyItems));
                Server.sendData(player, EnumPacketClient.MARCET_DATA, 2);
            }
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPlayerPacket.TraderMarketSell) {
            Marcet marcet = (Marcet)MarcetController.getInstance().getMarcet(buffer.readInt());
            if (marcet == null || marcet.notHasListener((EntityPlayer)player)) {
                Server.sendData(player, EnumPacketClient.MARCET_DATA, 2);
                Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
                return;
            }
            Deal deal = marcet.getDeal(buffer.readInt());
            if (deal == null || deal.getType() == 0 || deal.getProduct().isEmpty()) {
                Server.sendData(player, EnumPacketClient.MARCET_DATA, 2);
                Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
                return;
            }
            DealMarkup dm = MarcetController.getInstance().getBuyData(marcet, deal, data.game.getMarcetLevel(marcet.getId()));
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            ICustomNpc npc = null;
            if (entity instanceof EntityNPCInterface) {
                npc = (ICustomNpc)Objects.requireNonNull(NpcAPI.Instance()).getIEntity(entity);
            }
            if (marcet.isLimited) {
                boolean notSell = false;
                if (marcet.money < dm.sellMoney) {
                    notSell = true;
                } else {
                    marcet.money -= dm.sellMoney;
                }
                if (!(notSell || dm.sellItems.isEmpty() || Util.instance.canRemoveItems(marcet.inventory, dm.sellItems, dm.ignoreDamage, dm.ignoreNBT))) {
                    notSell = true;
                } else {
                    marcet.removeInventoryItems(dm.sellItems);
                }
                if (notSell) {
                    marcet.detectAndSendChanges();
                    Server.sendData(player, EnumPacketClient.MARCET_DATA, 2);
                    Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
                    return;
                }
            }
            if (player.field_71075_bZ.field_75098_d || Util.instance.removeItem(player, dm.main, dm.ignoreDamage, dm.ignoreNBT)) {
                if (!dm.sellItems.isEmpty()) {
                    boolean change = false;
                    for (ItemStack st : dm.sellItems.keySet()) {
                        for (int count = dm.sellItems.get(st).intValue(); count > 0; count -= st.func_77976_d()) {
                            ItemStack stc = st.func_77946_l();
                            stc.func_190920_e(Math.min(count, st.func_77976_d()));
                            if (!player.field_71071_by.func_70441_a(stc)) continue;
                            change = true;
                        }
                    }
                    if (change) {
                        NoppesUtilServer.playSound((EntityLivingBase)player, SoundEvents.field_187638_cR, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        Util.instance.updatePlayerInventory(player);
                    }
                    marcet.addInventoryItems(dm.sellItems);
                }
                if (dm.sellMoney > 0L) {
                    data.game.addMoney(dm.sellMoney);
                    marcet.money -= dm.sellMoney;
                }
                if (deal.getMaxCount() != 0) {
                    deal.setAmount(deal.getAmount() + dm.count);
                }
                if (CustomNpcs.SendMarcetInfo) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("mes.market.sell", new Object[]{dm.main.func_82833_r() + " x" + dm.count}));
                }
                data.game.addMarkupXP(marcet.getId(), 1);
                assert (npc != null);
                EventHooks.onNPCRole((EntityNPCInterface)((Object)npc.getMCEntity()), new RoleEvent.TraderEvent((EntityPlayer)player, npc, dm.main, dm.sellItems));
                marcet.detectAndSendChanges();
            } else {
                assert (npc != null);
                EventHooks.onNPCRole((EntityNPCInterface)((Object)npc.getMCEntity()), new RoleEvent.TradeFailedEvent((EntityPlayer)player, npc, dm.main, dm.sellItems));
                Server.sendData(player, EnumPacketClient.MARCET_DATA, 2);
            }
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPlayerPacket.TraderMarketReset) {
            Marcet m = (Marcet)MarcetController.getInstance().getMarcet(buffer.readInt());
            if (m != null) {
                m.updateNew();
            }
        } else if (type == EnumPlayerPacket.TraderMarketRemove) {
            Marcet m = (Marcet)MarcetController.getInstance().getMarcet(buffer.readInt());
            if (m != null) {
                m.removeListener((EntityPlayer)player, true);
            }
        } else if (type == EnumPlayerPacket.MailTakeMoney) {
            long id = buffer.readLong();
            PlayerMail mail = data.mailData.get(id);
            if (mail == null || mail.money <= 0) {
                return;
            }
            data.game.addMoney(mail.money);
            mail.money = 0;
            Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.MailData, data.mailData.saveNBTData(new NBTTagCompound())});
        } else if (type == EnumPlayerPacket.MailRansom) {
            long id = buffer.readLong();
            PlayerMail mail = data.mailData.get(id);
            if (mail != null && mail.ransom <= 0) {
                return;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                assert (mail != null);
                if (data.game.getMoney() < (long)mail.ransom) {
                    NoppesUtilServer.sendGuiError((EntityPlayer)player, 3);
                    return;
                }
            }
            assert (mail != null);
            data.game.addMoney((long)mail.ransom * -1L);
            mail.ransom = 0;
            Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.MailData, data.mailData.saveNBTData(new NBTTagCompound())});
        } else if (type == EnumPlayerPacket.GetBuildData) {
            ItemStack stack = player.func_184614_ca();
            BuilderData builder = null;
            if (stack.func_77973_b() instanceof ISpecBuilder) {
                builder = ItemBuilder.getBuilder(player.func_184614_ca(), (EntityPlayer)player);
            } else {
                int id = buffer.readInt();
                if (id >= 0) {
                    builder = SyncController.dataBuilder.get(id);
                }
            }
            if (builder != null) {
                Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.BuilderData, builder.getNbt()});
            }
        } else if (type == EnumPlayerPacket.HudTimerEnd) {
            int id = buffer.readInt();
            int orientationType = buffer.readInt();
            EventHooks.onPlayerTimer(data, id);
            data.hud.removeComponent(orientationType, id);
            data.hud.update();
        } else if (type == EnumPlayerPacket.TrackQuest) {
            data.hud.questID = buffer.readInt();
        } else if (type == EnumPlayerPacket.SaveCompassData) {
            data.hud.compassData.load(Server.readNBT(buffer));
        } else if (type == EnumPlayerPacket.GetTileData) {
            NBTTagCompound compound = Server.readNBT(buffer);
            TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z")));
            if (tile != null) {
                tile.func_189515_b(compound);
                Server.sendData(player, EnumPacketClient.SET_TILE_DATA, compound);
            }
        } else if (type == EnumPlayerPacket.ScriptPackage) {
            EventHooks.onScriptPackage((EntityPlayer)player, Server.readNBT(buffer));
        } else if (type == EnumPlayerPacket.MovingPathGet) {
            int id = buffer.readInt();
            Entity entity = player.field_70170_p.func_73045_a(id);
            if (entity instanceof EntityCustomNpc) {
                Server.sendData(player, EnumPacketClient.NPC_MOVING_PATH, id, ((EntityCustomNpc)entity).ais.writeToNBT(new NBTTagCompound()));
            }
        } else if (type == EnumPlayerPacket.KeyActive) {
            EventHooks.onPlayerKeyActive(player, buffer.readInt());
        } else if (type == EnumPlayerPacket.StopNPCAnimation) {
            DataAnimation animation;
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity instanceof EntityNPCInterface) {
                ((EntityNPCInterface)entity).animation.stopAnimation();
                EventHooks.onNPCStopAnimation((EntityNPCInterface)entity, buffer.readInt(), buffer.readInt());
            } else if (entity instanceof EntityPlayer && (animation = PlayerData.get((EntityPlayer)((EntityPlayer)entity)).animation) != null) {
                animation.stopAnimation();
            }
        } else if (type == EnumPlayerPacket.OpenGui) {
            EventHooks.onPlayerOpenGui(player, Server.readString(buffer), Server.readString(buffer));
        } else if (type == EnumPlayerPacket.GetFilePart) {
            int part = buffer.readInt();
            String name = Server.readString(buffer);
            if (!CommonProxy.downloadableFiles.containsKey(name)) {
                Server.sendData(player, EnumPacketClient.SEND_FILE_PART, true, name);
                return;
            }
            TempFile file = CommonProxy.downloadableFiles.get(name);
            Server.sendData(player, EnumPacketClient.SEND_FILE_PART, false, part, name, String.valueOf(file.data.get(part)));
        } else if (type == EnumPlayerPacket.GetSyncData) {
            SyncController.syncPlayer(player);
        } else if (type == EnumPlayerPacket.TransportCategoriesGet) {
            NoppesUtilServer.sendTransportData(player);
        } else if (type == EnumPlayerPacket.CustomGuiKeyPressed) {
            IPlayer pl = (IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player);
            if (pl.getCustomGui() == null || ((CustomGuiWrapper)pl.getCustomGui()).getScriptHandler() == null) {
                return;
            }
            EventHooks.onEvent(((CustomGuiWrapper)pl.getCustomGui()).getScriptHandler(), EnumScriptType.KEY_GUI_UP, (Event)new CustomGuiEvent.KeyPressedEvent(pl, pl.getCustomGui(), buffer.readInt()));
        } else if (type == EnumPlayerPacket.MarketTime) {
            MarcetController.getInstance().sendTo(player, buffer.readInt());
        } else if (type == EnumPlayerPacket.OpenCeilBank) {
            int bankId = buffer.readInt();
            BankData bd = data.bankData.get(bankId);
            if (bd != null) {
                EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                int ceilId = buffer.readInt();
                NoppesUtilPlayer.openBankGui(bd, player, npc, ceilId);
            }
        } else if (type == EnumPlayerPacket.NpcData) {
            int id = buffer.readInt();
            Entity e = player.field_70170_p.func_73045_a(id);
            if (e instanceof EntityNPCInterface) {
                NBTTagCompound compound = new NBTTagCompound();
                e.func_189511_e(compound);
                compound.func_74768_a("EntityID", id);
                Server.sendData(player, EnumPacketClient.NPC_DATA, compound);
            }
        } else if (type == EnumPlayerPacket.PlaySound) {
            if (player == null) {
                return;
            }
            EventHooks.onPlayerPlaySound(PlayerData.get((EntityPlayer)player).scriptData, new PlayerEvent.PlayerSound((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), Server.readString(buffer), Server.readString(buffer), Server.readString(buffer), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
        } else if (type == EnumPlayerPacket.StopSound) {
            if (player == null) {
                return;
            }
            EventHooks.onPlayerStopSound(data.scriptData, new PlayerEvent.PlayerSound((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), Server.readString(buffer), Server.readString(buffer), Server.readString(buffer), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
        } else if (type == EnumPlayerPacket.QuestExtraButton) {
            EventHooks.onEvent((IScriptHandler)data.scriptData, EnumScriptType.QUEST_LOG_BUTTON, (Event)new QuestEvent.QuestExtraButtonEvent((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), QuestController.instance.get(buffer.readInt())));
        } else if (type == EnumPlayerPacket.PlayerSkinSet) {
            PlayerSkinController pData = PlayerSkinController.getInstance();
            pData.loadPlayerSkin(Server.readNBT(buffer));
            pData.sendToAll(player);
        } else if (type == EnumPlayerPacket.ScriptEncrypt) {
            NBTTagCompound compound = Server.readNBT(buffer);
            int tab = compound.func_74762_e("Tab");
            IScriptHandler handler = null;
            switch (compound.func_74771_c("Type")) {
                case 0: {
                    NBTTagCompound scriptData = compound.func_74775_l("data");
                    TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(scriptData.func_74762_e("x"), scriptData.func_74762_e("y"), scriptData.func_74762_e("z")));
                    if (tile instanceof TileScripted) {
                        ((TileScripted)tile).setNBT(compound);
                        ((TileScripted)tile).lastInited = -1L;
                        handler = (TileScripted)tile;
                    }
                    if (!(tile instanceof TileScriptedDoor)) break;
                    ((TileScriptedDoor)tile).setNBT(compound);
                    ((TileScriptedDoor)tile).lastInited = -1L;
                    handler = (TileScriptedDoor)tile;
                    break;
                }
                case 1: {
                    handler = ScriptController.Instance.forgeScripts;
                    ((ForgeScriptData)handler).readFromNBT(compound);
                    ((ForgeScriptData)handler).lastInited = -1L;
                    break;
                }
                case 2: {
                    handler = ScriptController.Instance.playerScripts;
                    ((PlayerScriptData)handler).readFromNBT(compound);
                    ScriptController.Instance.playerScripts.readFromNBT(compound);
                    ((PlayerScriptData)handler).lastInited = -1L;
                    break;
                }
                case 3: {
                    handler = (ItemScriptedWrapper)Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(player.func_184614_ca());
                    ((ItemScriptedWrapper)handler).setScriptNBT(compound);
                    ((ItemScriptedWrapper)handler).lastInited = -1L;
                    break;
                }
                case 4: {
                    handler = ScriptController.Instance.potionScripts;
                    ((PotionScriptData)handler).readFromNBT(compound);
                    ((PotionScriptData)handler).lastInited = -1L;
                    break;
                }
                case 6: {
                    handler = ScriptController.Instance.npcsScripts;
                    ((NpcScriptData)handler).readFromNBT(compound);
                    ((NpcScriptData)handler).lastInited = -1L;
                    break;
                }
                case 7: {
                    Entity e = player.field_70170_p.func_73045_a(compound.func_74762_e("EntityID"));
                    if (!(e instanceof EntityNPCInterface)) {
                        return;
                    }
                    handler = ((EntityNPCInterface)e).script;
                    ((DataScript)handler).readFromNBT(compound);
                    ((DataScript)handler).lastInited = -1L;
                    break;
                }
            }
            boolean error = false;
            File file = new File(compound.func_74779_i("Path"));
            String filePath = file.getAbsolutePath();
            if (filePath.contains(".\\")) {
                filePath = filePath.substring(filePath.indexOf(".\\"));
            } else {
                File tempFile = new File(compound.func_74779_i("Path"));
                while (tempFile.getParentFile() != null && !new File(tempFile = tempFile.getParentFile(), "config").exists()) {
                }
                filePath = filePath.replace(tempFile.getParentFile() + "\\", "");
            }
            String handlerType = "";
            if (handler != null) {
                handlerType = " for " + handler.getClass().getSimpleName();
                ScriptContainer container = handler.getScripts().get(tab);
                boolean bl = error = container == null;
                if (!error) {
                    boolean onlyTab = compound.func_74767_n("OnlyTab");
                    String code = "";
                    if (onlyTab) {
                        code = container.script;
                    } else {
                        try {
                            Method getTotalCode = container.getClass().getDeclaredMethod("getTotalCode", new Class[0]);
                            getTotalCode.setAccessible(true);
                            code = (String)getTotalCode.invoke((Object)container, new Object[0]);
                            getTotalCode.setAccessible(false);
                        }
                        catch (Exception e) {
                            error = true;
                        }
                    }
                    if (!error) {
                        boolean bl2 = error = !ScriptEncryption.encryptScript(file, compound.func_74779_i("Name"), code, onlyTab, container, handler);
                        if (!error) {
                            compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages(false));
                            compound.func_74778_a("DirPath", ScriptController.Instance.dir.getAbsolutePath());
                            NBTTagCompound tabNBT = compound.func_150295_c("Scripts", 10).func_150305_b(tab);
                            if (!tabNBT.func_150296_c().isEmpty()) {
                                tabNBT.func_74778_a("Script", "");
                                NBTTagList scriptList = tabNBT.func_150295_c("ScriptList", 10);
                                boolean added = true;
                                for (int i = 0; i < scriptList.func_74745_c(); ++i) {
                                    if (!scriptList.func_150305_b(i).func_74779_i("Line").equals(compound.func_74779_i("Name"))) continue;
                                    added = false;
                                    break;
                                }
                                if (added) {
                                    NBTTagCompound nbtFile = new NBTTagCompound();
                                    nbtFile.func_74778_a("Line", compound.func_74779_i("Name"));
                                    scriptList.func_74742_a((NBTBase)nbtFile);
                                }
                            }
                            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
                        }
                    }
                }
            }
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a72CustomNPCs\u00a7" + (error ? "c: Error encrypt" : "7: Encrypt") + " script to file \"" + filePath + "\"" + handlerType));
        } else if (type == EnumPlayerPacket.MiniMapData) {
            data.minimap.loadNBTData(Server.readNBT(buffer));
        } else if (type == EnumPlayerPacket.InGame) {
            EventHooks.onEvent((IScriptHandler)data.scriptData, EnumScriptType.IN_GAME, (Event)new PlayerEvent.LoginEvent((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player)));
        } else if (type == EnumPlayerPacket.SendSyncData) {
            EnumSync synctype = EnumSync.values()[buffer.readInt()];
            SyncController.update(synctype, Server.readNBT(buffer), buffer, (EntityPlayer)player);
        } else if (type == EnumPlayerPacket.AcceptScripts) {
            ScriptController.Instance.setAgreement(Server.readString(buffer), buffer.readBoolean());
        } else if (type == EnumPlayerPacket.DropsData) {
            if (player.field_71075_bZ.field_75098_d && data.editingNpc != null && !data.editingNpc.func_70089_S() && data.editingNpc.inventory.deadLoots != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (EntityLivingBase e : data.editingNpc.inventory.deadLoots.keySet()) {
                    String name = e.func_70005_c_();
                    if (!(e instanceof EntityPlayer)) {
                        name = "\u00a77Mob: " + e.func_70005_c_();
                    }
                    list.add(name);
                }
                Collections.sort(list);
                Server.sendData(player, EnumPacketClient.SCROLL_LIST, list);
            }
        } else if (type == EnumPlayerPacket.DropData && player.field_71075_bZ.field_75098_d && data.editingNpc != null && !data.editingNpc.func_70089_S() && data.editingNpc.inventory.deadLoots != null) {
            DataInventory dataInv = data.editingNpc.inventory;
            String name = Server.readString(buffer);
            if (name != null) {
                int i = 0;
                int size = 9;
                for (EntityLivingBase e : dataInv.deadLoots.keySet()) {
                    String n = e.func_70005_c_();
                    if (!(e instanceof EntityPlayer)) {
                        n = "Mob: " + e.func_70005_c_();
                    }
                    if (n.equals(name)) {
                        size = dataInv.deadLoots.get(e).func_70302_i_();
                        break;
                    }
                    ++i;
                }
                NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.DeadInventory, data.editingNpc, size, i, 0);
            }
        }
    }

    static {
        list.add(EnumPlayerPacket.NpcVisualData);
        list.add(EnumPlayerPacket.IsMoved);
        list.add(EnumPlayerPacket.KeyPressed);
        list.add(EnumPlayerPacket.LeftClick);
        list.add(EnumPlayerPacket.MousesPressed);
        list.add(EnumPlayerPacket.StopNPCAnimation);
        list.add(EnumPlayerPacket.GetTileData);
        list.add(EnumPlayerPacket.GetFilePart);
        list.add(EnumPlayerPacket.MovingPathGet);
        list.add(EnumPlayerPacket.MarketTime);
        list.add(EnumPlayerPacket.NpcData);
        list.add(EnumPlayerPacket.PlaySound);
        list.add(EnumPlayerPacket.StopSound);
        list.add(EnumPlayerPacket.MiniMapData);
        list.add(EnumPlayerPacket.GetBuildData);
        list.add(EnumPlayerPacket.OpenGui);
    }
}

